#include "libkitten.h"

void Pixkitten::set_pixel (t_bunny_position pos, t_bunny_color color)
{
    if (!(pos.x < this->_width && pos.x >= 0 && pos.y < this->_height && pos.y >= 0))
        return;
    t_bunny_color clr[2];
    clr[0] = color;
    if (clr[0].argb[3] < 255 && clr[0].argb[3] > 0)
        {
            clr[1].full = get_pixel (pos);
            this->_pixel[pos.x + pos.y * this->_width] = color_ratio(clr, (unsigned int)clr[0].argb[3]).full;
        }
    else if (clr[0].argb[3] == 255)
        this->_pixel[pos.x + pos.y * this->_width] = color.full;
}

void Pixkitten::set_pixel (t_bunny_zposition pos, t_bunny_color color)
{
    t_bunny_position ps = {(int)pos.x, (int)pos.y};
    if (pos.z < this->_zpixel[ps.x + ps.y * this->_width] && pos.z < this->_depth)
        {
            this->set_pixel (ps, color_ratio (color, ratio(pos.z, 0, this->_depth)));
            this->_zpixel[ps.x + ps.y * this->_width] = pos.z;
        }
}

void Pixkitten::clear_pixelarray (t_bunny_color color)
{
    t_bunny_position pos;
    for (pos.y = 0; pos.y < this->_height; pos.y++)
        {
            for (pos.x = 0; pos.x < this->_width; pos.x++)
                this->set_pixel (pos, color);
        }
}

void Pixkitten::clear_zpixelarray (unsigned int color)
{
    t_bunny_color clr;
    clr.full = color;
    t_bunny_position pos;
    for (pos.y = 0; pos.y < this->_height; pos.y++)
        {
            for (pos.x = 0; pos.x < this->_width; pos.x++)
                this->_zpixel[pos.x + pos.y * this->_width] = this->_depth;
        }
    this->clear_pixelarray (clr);
}
