#include "libkitten.h"

static void horz_pos (Pixkitten* kitten, t_bunny_position* pos, t_bunny_position direction, t_bunny_color* color, int mult)
{
    t_bunny_position ps = pos[0];
    int e = direction.x;
    direction = {direction.x * 2, direction.y * 2};

    while (ps.x != pos[1].x)
        {
            if ((e -= direction.y * mult) < 0)
                {
                    ps.y += 1 * mult;
                    e += direction.x;
                }
            kitten->set_pixel (ps, color_ratio (color, ratio (ps.x, pos[0].x, pos[1].x)));
            ps.x++;
        }
}

static void horz_neg (Pixkitten* kitten, t_bunny_position* pos, t_bunny_position direction, t_bunny_color* color, int mult)
{
    t_bunny_position ps = pos[0];
    int e = direction.x;
    direction = {direction.x * 2, direction.y * 2};

    while (ps.x != pos[1].x)
        {
            if ((e += direction.y * mult) >= 0)
                {
                    ps.y += 1 * mult;
                    e += direction.x;
                }
            kitten->set_pixel (ps, color_ratio (color, ratio (ps.x, pos[0].x, pos[1].x)));
            ps.x--;
        }
}

static void vert_pos (Pixkitten* kitten, t_bunny_position* pos, t_bunny_position direction, t_bunny_color* color, int mult)
{
    t_bunny_position ps = pos[0];
    int e = direction.y;
    direction = {direction.x * 2, direction.y * 2};

    while (ps.y != pos[1].y)
        {
            if ((e -= direction.x * mult) < 0)
                {
                    ps.x += 1 * mult;
                    e += direction.y;
                }
            kitten->set_pixel (ps, color_ratio (color, ratio (ps.x, pos[0].x, pos[1].x)));
            ps.y++;
        }
}

static void vert_neg (Pixkitten* kitten, t_bunny_position* pos, t_bunny_position direction, t_bunny_color* color, int mult)
{
    t_bunny_position ps = pos[0];
    int e = direction.y;
    direction = {direction.x * 2, direction.y * 2};

    while (ps.y != pos[1].y)
        {
            if ((e -= direction.x * mult) >= 0)
                {
                    ps.x -= 1 * mult;
                    e += direction.y;
                }
            kitten->set_pixel (ps, color_ratio (color, ratio (ps.x, pos[0].x, pos[1].x)));
            ps.y--;
        }
}

void Pixkitten::set_line (t_bunny_position* pos, t_bunny_color* color)
{
    t_bunny_position dt = {pos[1].x - pos[0].x, pos[1].y - pos[0].y};

    if (dt.x != 0)
        {
            if (dt.x > 0)
                {
                    if (dt.y != 0)
                        {
                            if (dt.y > 0)
                                {
                                    if (dt.x > dt.y)
                                        horz_pos (this, pos, dt, color, 1);
                                    else //dt. <= dt.y
                                        vert_pos (this, pos, dt, color, 1);
                                }
                            else //dt.y <= 0
                                {
                                    if (dt.x > dt.y * -1)
                                        horz_pos (this, pos, dt, color, -1);
                                    else //dt.x <= dt.y * -1
                                        vert_neg (this, pos, dt, color, -1);
                                }
                        }
                    else //dt.y == 0
                        horz_pos (this, pos, dt, color, 1);
                }
            else //dt.x <= 0
                {
                    if (dt.y != 0)
                        {
                            if (dt.y > 0)
                                {
                                    if (dt.x * -1 > dt.y)
                                        horz_neg (this, pos, dt, color, 1);
                                    else //dt.x * -1 <= dt.y
                                        vert_pos (this, pos, dt, color, -1);
                                }
                            else //dt.y <= 0
                                {
                                    if (dt.y > dt.x)
                                        horz_neg (this, pos, dt, color, -1);
                                    else //dt.y <= dt.x
                                        vert_neg (this, pos, dt, color, 1);
                                }
                        }
                    else //dt.x == 0
                        horz_neg (this, pos, dt, color, 1);
                }
        }
    else //dt.x == 0
        {
            if (dt.y != 0)
                {
                    if (dt.y > 0)
                        vert_pos (this, pos, dt, color, 1);
                    else //dt.y <= 0
                        vert_neg (this, pos, dt, color, 1);
                }
        }
}
