#include "libkitten.h"

static void demi_triangle (Pixkitten* kitten, t_bunny_position* pos, t_bunny_color* color, int mult)
{
    t_bunny_position ps[2];
    t_bunny_color clr[2];
    t_bunny_color a[2] = {color[0], color[1]};
    t_bunny_color b[2] = {color[0], color[2]};

    for (ps[0].y = ps[1].y = pos[0].y; ps[0].y != (pos[1].y + mult); ps[0].y = ps[1].y += 1 * mult)
        {
            ps[0].x = (pos[1].x - pos[0].x) * ratio(ps[0].y, pos[0].y, pos[1].y) + pos[0].x;
            ps[1].x = (pos[2].x - pos[0].x) * ratio(ps[1].y, pos[0].y, pos[2].y) + pos[0].x;
            clr[0] = color_ratio (a, ratio(ps[0].y, pos[0].y, pos[1].y));
            clr[1] = color_ratio (b, ratio(ps[1].y, pos[0].y, pos[2].y));
            kitten->set_line (ps, clr);
        }
}

void Objkitten::set_triangle (t_bunny_position* pos, t_bunny_color* color, bool empty)
{
    if (empty == false)
        {
            t_bunny_position sort_pos[3] = {pos[0], pos[1], pos[2]};
            t_bunny_color sort_color[3] = {color[0], color[1], color[2]};
            sort_position (sort_pos, sort_color, 3, false);

            t_bunny_position new_pos[3] = {sort_pos[0], sort_pos[1], {(int)((sort_pos[2].x - sort_pos[0].x) * ratio(sort_pos[1].y, sort_pos[0].y, sort_pos[2].y) + sort_pos[0].x), sort_pos[1].y}};
            t_bunny_color temp[2] = {sort_color[0], sort_color[2]};
            t_bunny_color new_color[3] = {sort_color[0], sort_color[1], color_ratio(temp, ratio(sort_pos[1].y, sort_pos[0].y, sort_pos[2].y))};

            demi_triangle (this->_pixelarray, new_pos, new_color, 1);

            new_pos[0] = sort_pos[2];
            new_pos[1] = {(int) ((sort_pos[1].x - sort_pos[0].x) * ratio(sort_pos[1].y+1, sort_pos[1].y, sort_pos[2].y) + sort_pos[1].x), sort_pos[1].y+1};
            new_pos[2] = {(int) ((sort_pos[2].x - sort_pos[0].x) * ratio(sort_pos[1].y+1, sort_pos[0].y, sort_pos[2].y) + sort_pos[0].x), sort_pos[1].y+1};
            new_color[0] = sort_color[2];
            new_color[2] = color_ratio(temp, ratio(sort_pos[1].y+1, sort_pos[0].y, sort_pos[2].y));
            temp[0] = sort_color[1];
            new_color[1] = color_ratio(temp, ratio(sort_pos[1].y+1, sort_pos[1].y, sort_pos[2].y));

            demi_triangle (this->_pixelarray, new_pos, new_color, -1);
        }
    else
        {
            t_bunny_position ps[2] = {pos[0], pos[1]};
            t_bunny_color clr[2] = {color[0], color[1]};
            this->_pixelarray->set_line (ps, clr);

            ps[1] = pos[2];
            clr[1] = color[2];
            this->_pixelarray->set_line (ps, clr);

            ps[0] = pos[1];
            clr[0] = color[1];
            this->_pixelarray->set_line (ps, clr);
        }
}
