#include "lk_window.hpp"

void Winkitten::set_pixel (t_bunny_position pos, unsigned int color)
{
    if (!(pos.x < _pixelarray->clipable.buffer.width && pos.x >= 0 
    && pos.y < _pixelarray->clipable.buffer.height && pos.y >= 0))
        return;
    _pixels[pos.x + pos.y * _pixelarray->clipable.buffer.width] = color;
}

void Winkitten::clear_pixelarray (t_bunny_position* pos, unsigned int color)
{
    t_bunny_position ps;
    for (ps.y = pos[0].y; ps.y < pos[1].y; ps.y++)
        for (ps.x = pos[0].x; ps.x < pos[1].x; ps.x++)
            this->set_pixel (ps, color);
}


//fonction static
static t_bunny_response st_key (t_bunny_event_state state, t_bunny_keysym key, void* dt)
{
    (void)dt;
    return (win_gl->key(state, key));
}

static t_bunny_response st_loop (void* dt)
{
    (void)dt;
    return (win_gl->loop());
};


//fontion virtual
t_bunny_response Winkitten::key(t_bunny_event_state state, t_bunny_keysym sym)
{
    (void)state;
    if (sym == BKS_ESCAPE)
        return (EXIT_ON_SUCCESS);
    return (GO_ON);
}

t_bunny_response Winkitten::loop(void)
{
    bunny_blit (&win_gl->get_win()->buffer, &win_gl->get_pixelarray()->clipable, NULL);
    bunny_display (win_gl->get_win());
    return (GO_ON);
}

void Winkitten::start(Winkitten &win)
{
    win_gl = &win;
    bunny_set_key_response(st_key);
    bunny_set_loop_main_function(st_loop);
    bunny_loop(_window, 24, NULL);
};

Winkitten* win_gl;