#include "libkitten.h"

double ratio (double here, double from, double to)
{
    //ratio
    if (to - from != 0.0)
        return ((here - from) / (to - from));
    return (0.0);
}

unsigned int color_ratio (unsigned int* col, unsigned int ratio)
{
    //alpha ratio
    t_bunny_color color[2] = {{col[0]}, {col[1]}};

    t_bunny_color bonite;
    bonite.argb[0] = (color[0].argb[0] * (ratio / 255.0) + (color[1].argb[0] * (1 - ratio / 255.0)));
    bonite.argb[1] = (color[0].argb[1] * (ratio / 255.0) + (color[1].argb[1] * (1 - ratio / 255.0)));
    bonite.argb[2] = (color[0].argb[2] * (ratio / 255.0) + (color[1].argb[2] * (1 - ratio / 255.0)));
    bonite.argb[3] = 255;
    return bonite.full;
}

unsigned int color_ratio (unsigned int* color, double ratio)
{
    //color ratio
    t_bunny_color colin[2] = {{color[0]}, {color[1]}};
    colin[0].argb[0] = (colin[0].argb[0] * (1 - ratio)) + (colin[1].argb[0] * ratio);
    colin[0].argb[1] = (colin[0].argb[1] * (1 - ratio)) + (colin[1].argb[1] * ratio);
    colin[0].argb[2] = (colin[0].argb[2] * (1 - ratio)) + (colin[1].argb[2] * ratio);
    colin[0].argb[3] = (colin[0].argb[3] * (1 - ratio)) + (colin[1].argb[3] * ratio);
    return colin[0].full;
}

unsigned int color_ratio (unsigned int color, double ratio)
{
    //detph ratio
    t_bunny_color saumon = {color};
    saumon.argb[0] = saumon.argb[0] - (saumon.argb[0] * ratio);
    saumon.argb[1] = saumon.argb[1] - (saumon.argb[1] * ratio);
    saumon.argb[2] = saumon.argb[2] - (saumon.argb[2] * ratio);
    return saumon.full;
}
