#ifndef LK_WINDOW_HPP_
#define LK_WINDOW_HPP_

#include <lapin.h>

class Winkitten
{
private:
    t_bunny_pixelarray* _pixelarray;
    t_bunny_window* _window;
    unsigned int* _pixels;

public:
    Winkitten(int width, int height) 
    {
        _window = bunny_start(width, height, false, "Kitten_Windows");
        _pixelarray = bunny_new_pixelarray(width, height);
        _pixels = (unsigned int*)_pixelarray->pixels;
    };
    ~Winkitten(void) = default;

    void start(Winkitten& win);

    t_bunny_pixelarray* get_pixelarray(void) const
    {
        return _pixelarray;
    };
    t_bunny_window* get_win(void) const
    {
        return _window;
    };

    void set_pixel(t_bunny_position pos, unsigned int color);
    void clear_pixelarray(t_bunny_position* pos, unsigned int color);
    void set_line(t_bunny_position* pos, unsigned int* color);

    virtual t_bunny_response loop(void);
    virtual t_bunny_response key(t_bunny_event_state state, t_bunny_keysym sym);
};

extern Winkitten* win_gl;

#endif
